/*------------------------------------------------------------------------------*
 * File Name: MSWin.h															*
 * Creation: CPY 4/12/2001														*
 * Purpose: Win32 functions														*
 * Copyright (c) OriginLab Corp.2001											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * CPY 11/15/02 v7.0434 ORIGIN_8_FEATURES										*	
 * Folger 11/13/07 EXPOSE_GET_FOCUS												*
 * AW 02/02/09 QA80-13048 SUPPORT_NAMED_PIPE_IN_ORIGINC							*
 *	ML CPY 1/28/2010 VSFLEXGRID_NEEDS_IDENTIFIER_FOR_RANOREX					*
 *	Folger 07/05/10 ORG-436 BETTER_USE_OC_DEVICE_CONTEXT						*
 *------------------------------------------------------------------------------*/
#ifndef _MSWIN_H
#define _MSWIN_H

#ifndef _OC_TYPES_H
#include <OC_types.h> // if not already included, this will provide SYSTEMTIME
#endif

#define FAR 	//CPY 10/16/05 QA70-8183, after this fix, add this so typedef for many mswin types can be used without modification

//--------------------------------------------------------------------------
// From Microsoft's windef.h
//--------------------------------------------------------------------------
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:COLORREF
*/
typedef DWORD COLORREF;
typedef DWORD *LPCOLORREF;

//--------------------------------------------------------------------------
// From Microsoft's wingdi.h
//--------------------------------------------------------------------------
/* Logical Font */
#define LF_FACESIZE         32

#define RGB(r,g,b) ((COLORREF)(((BYTE)(r)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(b))<<16)))

#define GetRValue(rgb)      ((BYTE)(rgb))
#define GetGValue(rgb)      ((BYTE)(((WORD)(rgb)) >> 8))
#define GetBValue(rgb)      ((BYTE)((rgb)>>16))

// some colors
#ifndef COLOR_RED
	#define COLOR_RED		RGB(255,0,0)
	#define COLOR_GREEN		RGB(0,255,0)
	#define COLOR_BLUE		RGB(0,0,255)
	#define COLOR_YELLOW	RGB(255,255,0)
	
	#define COLOR_NAVY		RGB(0,0,128)	
	#define COLOR_LTYELLOW	RGB(255,255,128)
	#define COLOR_ORANGE	RGB(255,128,0)
	
	#define COLOR_BLACK		RGB(0,0,0)
	#define COLOR_WHITE		RGB(255,255,255)
#endif

#define ANSI_CHARSET            0
#define DEFAULT_CHARSET         1
#define SYMBOL_CHARSET          2
#define SHIFTJIS_CHARSET        128


//--------------------------------------------------------------------------
// From Microsoft's winuser.h
//--------------------------------------------------------------------------
#define WM_CLOSE                        0x0010
#define WM_QUERYENDSESSION              0x0011



//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//--- CPY 10/19/04 ORIGIN8_NEED_POINT_RELATED_FUNCTIONS
#if _OC_VER >= 0x0800
// Comments last updated by Frank on 04/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:POINT
*/
typedef struct tagPOINT
{
    LONG  x;
    LONG  y;
} POINT;


#endif // _OC_VER >= 0x0800
//--- end ORIGIN8_NEED_POINT_RELATED_FUNCTIONS


//-------- CPY 11/15/02 v7.0434 ORIGIN_8_FEATURES
// Origin 8 or later
#if  _OC_VER > 0x0703

/// YuI 11/27/06 QA70-9156 MORE_OPTIONS_TO_CONNECTING_OBJECTS
// moved to <OC_types.h>
// Comments last updated by Frank on 04/29/2005
/**
	The RECT structure defines the coordinates of the upper-left and lower-right corners of a rectangle. 

	Members
		left 
		Specifies the x-coordinate of the upper-left corner of the rectangle. 
		top 
		Specifies the y-coordinate of the upper-left corner of the rectangle. 
		right 
		Specifies the x-coordinate of the lower-right corner of the rectangle. 
		bottom 
		Specifies the y-coordinate of the lower-right corner of the rectangle. 
*/
/*
typedef struct tagRECT
{
    int    left;
    int    top;
    int    right;
    int    bottom;
} RECT;
#define RECT_WIDTH(_RR) (_RR.right - _RR.left)
#define RECT_HEIGHT(_RR) (_RR.bottom - _RR.top)
#define RECT_X(_RR)		((_RR.left + _RR.right)/2)
#define RECT_Y(_RR)		((_RR.bottom + _RR.top)/2)
*/
/// end MORE_OPTIONS_TO_CONNECTING_OBJECTS

// Comments last updated by Frank on 04/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SIZE
*/
typedef struct tagSIZE
{
    LONG	cx;
    LONG    cy;
} SIZE;
// Comments last updated by Frank on 04/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GUID
*/
typedef struct _GUID {          // size is 16
    DWORD Data1;
    WORD   Data2;
    WORD   Data3;
    BYTE  Data4[8];
} GUID;


/* Stock Logic fonts */
#define ORIGIN_FIXED_FONT	(-1)
#define ORIGIN_VAR_FONT		(-2)
#define ORIGIN_MENU_FONT	(-3)

#define OEM_FIXED_FONT      10
#define ANSI_FIXED_FONT     11
#define ANSI_VAR_FONT       12
#define SYSTEM_FONT         13
#define DEVICE_DEFAULT_FONT 14
#define SYSTEM_FIXED_FONT   16
#define DEFAULT_GUI_FONT    17


#define LOGPIXELSX    88    /* Logical pixels/inch in X                 */
#define LOGPIXELSY    90    /* Logical pixels/inch in Y                 */

#define HDC LPVOID

// Comments last updated by Frank on 03/16/2005
/**+
http://ocwiki.originlab.com/index.php?title=Category:DeviceContext_(class)
*/
class DeviceContext
{
public:

	// Comments last updated by Frank on 03/16/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DeviceContext-DeviceContext
	*/
	DeviceContext();
	
	// Comments last updated by Frank on 03/16/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DeviceContext-DeviceContext
	*/
	DeviceContext(DeviceContext &dc);

	/**#
	*/
	///------ Folger 07/05/10 ORG-436 BETTER_USE_OC_DEVICE_CONTEXT
	DeviceContext(Window& win);
	///------ End BETTER_USE_OC_DEVICE_CONTEXT
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DeviceContext-~DeviceContext
	*/
	~DeviceContext();
	
public:
	
	// Comments last updated by Frank on 03/16/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DeviceContext-Attach
	*/
	BOOL Attach(HDC hDC );

	// Comments last updated by Frank on 03/16/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DeviceContext-Detach
	*/
	HDC Detach( );

	// Comments last updated by Frank on 03/16/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DeviceContext-GetDeviceCaps
	*/
	int GetDeviceCaps(int nIndex) const;

	// Comments last updated by Frank on 03/16/2005
	/**#
		Computes the width and height of a line of text on the attribute device context using the current font to determine the dimensions.
	Example1:
		void DeviceContext_GetTextExtent_ex1()
		{
			Window wnd = MyDlg.GetWindow();
			DeviceContext dc = wnd.GetDC();
			SIZE sz[10];
			sz[2] = dc.GetTextExtent("ABC",3);
			out_int("x_width = ", sz[2].cx);
			out_int("y_width = ", sz[2].cy);
		}
	Parameters:
		lpszString =[input] Points to a string of characters. 
		nCount = [input] Specifies the number of characters in the string.
	Return:
		The dimensions of the string (in logical units) in a SIZE structure.


	*/
	SIZE GetTextExtent(LPCTSTR lpszString, int nCount);

	// Comments last updated by Frank on 03/16/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:DeviceContext-GetTextExtent
	*/
	SIZE GetTextExtent(const string &str);
};

// Comments last updated by Joseph on 04/09/2007
///From msdn of class CCmdTarget
/**+
http://ocwiki.originlab.com/index.php?title=Category:CmdTarget_(class)
*/
class CmdTarget
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:CmdTarget-CmdTarget
	*/
	CmdTarget();
	
protected:

	// Comments last updated by Frank on 03/16/2005
	/**
		Each framework class that can receive messages or commands has its own "message map." The framework
		uses message maps to connect messages and commands to their handler functions. Any class derived from 
		class CCmdTarget can have a message map. Other articles explain message maps in detail and describe how
		to use them.
		In spite of the name "message map," message maps handle both messages and commands  all three categories 
		of messages Windows messages, Control notifications, Command messages. 
	*/
	Msgmap m_msgmap;
};

#if _OC_VER >= 0x0800
/**# >User Interface Controls
		The PictureHolder class is utility class to handle various kind of picture objects an display them in a dialog or VSFlex grid
		This class is similar to the MFC CPictureHolder class
	Example1:
		// put following code into a file and put inside OriginC\Originlab folder
		// the dialog resource in odlg8 inside that location is used for this sample to work.
		// In this example, we first create an XML file with two pictures from the NLSF function
		// preview and then we show them in the top and bottom pane of a dialog
#include <Origin.h>
#include <Dialog.h>

#include "HelpID.h"
#include "Odlg8.h"
#include "ResizeDialog.h"
#include "MultiPaneDlg.h"

#include <ocGDI.h>
	
///////////////////////////	
class Pict2Dlg : public MultiPaneDlg
{
public:
	Pict2Dlg(LPCSTR lpcszPictFilename) : MultiPaneDlg(IDD_PRESENTATION_MANAGER, "ODlg8") // use Presentation Manager resource,
	{
		m_strFilename = lpcszPictFilename;
	}	
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		return DoModal(hWndParent);
	}
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	ON_BN_CLICKED(IDC_PM_SHOW_PE, OnShowBottomPane)
EVENTS_END

//------------ Event Handlers ------------------------
	BOOL OnInitDialog()
	{
		waitCursor junk;
		//Profiler jj;
		//---- the following are standard codes needed for MultiPaneDlg dialog
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.SetSize(2);
		vstrTipsUpDown[0] = _L("Show Function Preview Cuves");
		vstrTipsUpDown[1] = _L("Hide Function Preview Cuves");
		MultiPaneDlg::OnInitDialog(IDC_PM_PRESENTATIONS, IDC_PM_SHOW_PE, vstrTipsUpDown, "Pict2TestDlg");
		//----
		
		// here is the real stuff for our picture controls
    	Control ctrl = GetDlgItem(IDC_PM_PRESENTATIONS);
    	m_Top.CreateControl(ctrl.GetSafeHwnd());
		Control ctrl2 = GetDlgItem(IDC_PM_PE_PAGES);
    	m_Bottom.CreateControl(ctrl2.GetSafeHwnd());
    	
    	loadPicturesIntoTopAndBottomPanes();
		
    	m_Top.Visible = true;
		SetInitReady();
		return true;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
			
		uint nButtonIDs[] = {IDOK, IDC_PM_NEW, IDC_PM_ADD, IDC_PM_REMOVE, 0};
		MultiPaneDlg::OnDlgResize(IDC_PM_PRESENTATIONS, IDC_PM_PE_PAGES, nButtonIDs, cx, cy);
		return TRUE;
	}
	
	//////////// local utilities/helper functions
private:
	void loadPicturesIntoTopAndBottomPanes()
	{
		Tree tr;
		string strTreeName = GetAppPath() + m_strFilename;
		tr.Load(strTreeName);
		// assume it has Pict1 and Pict2
		if(!tr.Pict1.IsValid())
			return;
		
		PictureHolder pictHold(tr.Pict1.pict);
		m_Top.SetPicture(pictHold);
		
		PictureHolder pictHold2(tr.Pict2.pict);
		m_Bottom.SetPicture(pictHold2);
	}
	PictureControl	m_Top;
	PictureControl	m_Bottom;
	string			m_strFilename;
};

/////////////////////////////////////////

bool CreatPictTreeUsingNLSFPreviewPictures(string strFilename, string strFuncName)
{
	// the following 2 files hold many metafile images for NLSF functions
	string strEquationGroupFile = "fgroup.oqs";
	string strCurveGroupFile = "fgroup.ocs";

	Tree TreePicts;
	
	HMETAFILE hmf;
	RECT16 rect;
	
	
	string strPathName = GetAppPath(TRUE);
	string strPackedPictName = strPathName + strEquationGroupFile;
	
	hmf = get_packed_metafile(strPackedPictName, strFuncName, &rect);
	
	PictureHolder pictHold;
	if(NULL == hmf || !pictHold.CreateFromMetafile(hmf, rect.right, rect.bottom, TRUE))
		return false;

	// if we get this far, then things are looking good
	TreePicts.Pict1.pict =  pictHold;
	
	strPackedPictName = strPathName + strCurveGroupFile;
	hmf = get_packed_metafile(strPackedPictName, strFuncName, &rect);
	if(hmf)
	{
		pictHold.CreateFromMetafile(hmf, rect.right, rect.bottom, TRUE);
		TreePicts.Pict2.pict =  pictHold;
	}
	string strTreeName = GetAppPath() + strFilename;
	TreePicts.Save(strTreeName);
	return true;
}

// main entry, 
// from script window
// pic;
void Pic(string strFuncName = "expdecy3", string strFilename = "MyTest.xml")
{
	if(!CreatPictTreeUsingNLSFPreviewPictures(strFilename, strFuncName))
	{
		out_str("failed to create pict tree, maybe wrong function name");
		return;
	}
	
	Pict2Dlg dlg(strFilename);
	dlg.DoModalEx(GetWindow());
}

*/
class PictureHolder
{
public:
	
	/**#
			PictureHolder, Default constructor
	*/
	PictureHolder();//Default constor
	/**#
			PictureHolder, copy constructor
	*/
	PictureHolder(const PictureHolder& phOriginal);//Copy constructor
	
public:
	
	// Comments last updated by Frank on 03/16/2005
	/**#
			CreateFromBitmap, creates a PictureHolder object from a handle to BitMap
		Return:
			FALSE if failed.
		Example1:
			//Case 1: Test bTransferOwnership = true, hbp should be destroy destruction of the instance of PictureHolder object
			int PictureHolder_CreateFromBitmap_ex1()
			{
				GraphPage gp;
				gp.Create("origin.otp");
				HBITMAP hbp ;
				if( !gp.IsValid() )
					return -1;
				else
				{
					hbp = gp.CreateImage(CF_BITMAP, 600,0);
					PictureHolder ph;
					ph.CreateFromBitmap(hbp,true);
					if(!ph)
						out_str("Create fail");
				}
				
				PictureHolder phCheckOwner;
				
				if(phCheckOwner.CreateFromBitmap(hbp,false))
				{
					out_str("error, hbp should destroy of PictureHolder deconstruct.");
				}
				return 0;
			}
			//Case 2: Test bTransferOwnership = false, hbp should not destroy destruction of the instance of PictureHolder object
			int PictureHolder_CreateFromBitmap_ex2()
			{
				GraphPage gp;
				gp.Create("origin.otp");
				HBITMAP hbp ;
				if( !gp.IsValid() )
					return -1;
				else
				{
					hbp = gp.CreateImage(CF_BITMAP, 600,0);
					PictureHolder ph;
					ph.CreateFromBitmap(hbp,false);
					if(!ph)
						out_str("Create fail");
				}
				
				PictureHolder phCheckOwner;
				
				if(!phCheckOwner.CreateFromBitmap(hbp,false))
				{
					out_str("Error, hbp should not be destroy of PictureHolder deconstruct.");
				}
				return 0;
			}

		Parameters:
			hbm =[input] Handle to bitmap, from which the PictureHolder object is created 
			bTransferOwnership = [input] if TRUE, the PictureHolder object becomes the new owner of the object,
								hbm is destroed on destruction of the instance of PictureHolder object
	*/
	BOOL CreateFromBitmap( HBITMAP hbm,  BOOL bTransferOwnership = FALSE);
	// Comments last updated by Frank on 03/16/2005
	/**#
			CreateFromEnhMetafile, creates a PictureHolder object from a handle to Enhanced Metafile
			if using bTransferOwnership = TRUE, hmf is destroed on destruction of the instance of PictureHolder object
		Return:
			FALSE if failed.
		Example1:
			int PictureHolder_CreateFromEnhMetafile_ex1()
			{
				GraphPage gp;
				gp.Create("origin.otp");
				
				HENHMETAFILE	hemf;
				
				if( !gp.IsValid() )
					return -1;
				else
				{
					hemf = gp.CreateImage(CF_ENHMETAFILE,600,0);
					PictureHolder ph;
					ph.CreateFromEnhMetafile(hemf,true);
					if(!ph)
						out_str("Create fail");
				}
				
				PictureHolder phCheckOwner;
				
				if(phCheckOwner.CreateFromEnhMetafile(hemf,false))
				{
					out_str("error, hbp should destroy of PictureHolder deconstruct.");
				}
				return 0;
			}
			int PictureHolder_CreateFromEnhMetafile_ex2()
			{
				GraphPage gp;
				gp.Create("origin.otp");
				
				HENHMETAFILE	hemf;
				
				if( !gp.IsValid() )
					return -1;
				else
				{
					hemf = gp.CreateImage(CF_ENHMETAFILE,600,0);
					PictureHolder ph;
					ph.CreateFromEnhMetafile(hemf,false);
					if(!ph)
						out_str("Create fail");
				}
				
				PictureHolder phCheckOwner;
				
				if(!phCheckOwner.CreateFromEnhMetafile(hemf,false))
				{
					out_str("Error, hbp should not be destroy of PictureHolder deconstruct.");
				}
				return 0;
			}
		Parameters:
			hmf =[input] Handle to a enhanced metafile, from which the PictureHolder object is created 
			bTransferOwnership = [input] if TRUE, the PictureHolder object becomes the new owner of the object
	*/
	BOOL CreateFromEnhMetafile(HENHMETAFILE hmf, BOOL bTransferOwnership = FALSE );
	// Comments last updated by Frank on 03/16/2005
	/**#
			CreateFromMetafile, creates a PictureHolder object from a handle to Metafile
		Return:
			FALSE if failed.
		Example1:
			int PictureHolder_CreateFromMetafile_ex1()
			{
				
				GraphPage gp;
				gp.Create("origin.otp");
				
				HMETAFILE hmf ;
	
				RECT rect;
				if(!gp.IsValid())
					return -1;
				else
				{
					Window gpWin = gp.GetWindow();
					gpWin.GetWindowRect(&rect);
					hmf = gp.CreateImage(CF_METAFILEPICT, 600,0);
					PictureHolder phDst;
					phDst.CreateFromMetafile( hmf, rect.right - rect.left, rect.bottom - rect.top , true);

					if(!phDst)
						out_str("Create fail");
				}
				PictureHolder phCheckOwner;

				if(phCheckOwner.CreateFromMetafile( hmf, rect.right - rect.left, rect.bottom - rect.top , true))
				{
					out_str("Error, hmf should be destroy of PictureHolder deconstruct.");
				}
				return 0;
			}
			int PictureHolder_CreateFromMetafile_ex2()
			{
				
				GraphPage gp;
				gp.Create("origin.otp");
				
				HMETAFILE hmf ;
	
				RECT rect;
				if(!gp.IsValid())
					return -1;
				else
				{
					Window gpWin = gp.GetWindow();
					gpWin.GetWindowRect(&rect);
					hmf = gp.CreateImage(CF_METAFILEPICT, 600,0);
					PictureHolder phDst;
					phDst.CreateFromMetafile( hmf, rect.right - rect.left, rect.bottom - rect.top , false);

					if(!phDst)
						out_str("Create fail");
				}
				PictureHolder phCheckOwner;

				if(!phCheckOwner.CreateFromMetafile( hmf, rect.right - rect.left, rect.bottom - rect.top , true))
				{
					out_str("Error, hmf should not be destroy of PictureHolder deconstruct.");
				}
				return 0;
			}
		Parameters:
			hmf = [input] Handle to an metafile, from which the PictureHolder object is created
			xExt = [input] Horizontal extent of the metafile in TWIPS units 
			yExt = [input] Vertical extent of the metafile in TWIPS units 
			bTransferOwnership = [input] if TRUE, the PictureHolder object becomes the new owner of the object,
								hmf is destroed on destruction of the instance of PictureHolder object.
	*/
	BOOL CreateFromMetafile( HMETAFILE hmf, int xExt, int yExt, BOOL bTransferOwnership = FALSE );
	/**#
			CreateFromIcon, creates a PictureHolder object from a handle to an Icon
			if using bTransferOwnership = TRUE, hIcon is destroed on destruction of the instance of PictureHolder object
		Return:
			FALSE if failed.

		Parameters:
			hIcon = [input] Handle to an icon, from which the PictureHolder object is created 
			bTransferOwnership = [input] if TRUE, the PictureHolder object becomes the new owner of the object
	*/
	BOOL CreateFromIcon(HICON hIcon, BOOL bTransferOwnership = FALSE);
	// Comments last updated by Frank on 03/16/2005
	/**#
			Load, Loads a picture object from a bmp file
		Example1:
			int	PictureHolder_Load_ex1()
			{
				string strBitMapPath = GetAppPath(true) + "Userdef.bmp";
				PictureHolder phDst;
				phDst.Load(strBitMapPath);
				if(!phDst)
					out_str("Fail");

				return 0;
			}
		Return:
			FALSE if failed.

		Parameters:
			strBitmapFilename =[input] BitMap file name, with full path
	*/
	BOOL Load(LPCTSTR strBitmapFilename);
	
	// Comments last updated by Frank on 03/16/2005
	/**#
		GetWidth, Gets a width of picture object
		Example1:
			int PictureHolder_GetWidth_ex1()
			{
				GraphPage gp;
				gp.Create("origin.otp");
				if( gp.IsValid() )
				{
					HBITMAP hbp = gp.CreateImage(CF_BITMAP, 600,0);
					PictureHolder ph;
					ph.CreateFromBitmap(hbp,true);
					if(!ph)
						return -1;
					int nWidth = ph.GetWidth();
					out_int("The image width is ", nWidth);
				}
				return 0;
			}	
		Return:
			Width of Picture.
	*/
	int	GetWidth();
	
	// Comments last updated by Frank on 03/16/2005
	/**#
		GetWidth, Gets a Height of picture object
		Example1:
			int PictureHolder_GetHeight_ex1()
			{
				GraphPage gp;
				gp.Create("origin.otp");
				if( gp.IsValid() )
				{
					HBITMAP hbp = gp.CreateImage(CF_BITMAP, 600,0);
					PictureHolder ph;
					ph.CreateFromBitmap(hbp,true);
					if(!ph)
						return -1;
					int nHeight = ph.GetHeight();
					out_int("The image heiht is ", nHeight);
				}
				return 0;
			}
		Return:
			Height of Picture.
	*/
	int	GetHeight();
};

/**#
*/
class	ObjectCmdTarget	:	public	CmdTarget
{
public:
	/**#
	*/
	ObjectCmdTarget();
public:
	/**#
	*/
	BOOL	GetSender(OriginObject& objSender);
};
#endif //  _OC_VER >= 0x0800		

/**+
http://ocwiki.originlab.com/index.php?title=Category:Window_(class)
*/
class Window :public CmdTarget
{
public:
	
	// Comments last updated by Frank on 03/23/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-Window
	*/
	Window();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-Window
	*/
	Window(HWND hWnd);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-Window
	*/
	Window(Window& ctrl);
	
	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-GetSafeHwnd
	*/
	HWND	GetSafeHwnd();	
	
	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-Attach
	*/
	BOOL	Attach(Window& ctrl);
	
	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-SetScrollPos
	*/
	int SetScrollPos( int nBar, int nPos, BOOL bRedraw = TRUE );

	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-SetScrollRange
	*/
	void SetScrollRange( int nBar, int nMinPos, int nMaxPos, BOOL bRedraw = TRUE );

	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-GetScrollPos
	*/
	int GetScrollPos( int nBar ) const;

	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-GetScrollRange
	*/
	void GetScrollRange( int nBar, int& nMinPos, int& nMaxPos ) const;

	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-SendMessage
	*/
	UINT	SendMessage(uint msg, DWORD wParam = 0, DWORD lParam = 0);

	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-PostMessage
	*/
	BOOL	PostMessage(uint msg, DWORD wParam = 0, DWORD lParam = 0);

	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-ShowWindow
	*/
	BOOL	ShowWindow(int nCmdShow);
	
	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-MoveWindow
	*/
	void	MoveWindow(const RECT * lpRect, BOOL bRepaint = TRUE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-SizeInSplitter
	*/
	void	SizeInSplitter(SIZE &size);

	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-GetWindowRect
	*/
	void	GetWindowRect(RECT * lpRect);

	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-GetClientRect
	*/
	void	GetClientRect(RECT * lpRect);

	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-ClientToScreen
	*/
	void	ClientToScreen(RECT * lpRect); 

	//void	ClientToScreen(point * lpPoint);

//	void	ScreenToClient(point * lpPoint);

	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-ScreenToClient
	*/
	void	ScreenToClient(RECT * lpRect);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-Enable
	*/
	BOOL	Enable;

	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-Visible
	*/
	BOOL	Visible;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-Text
	*/
	string	Text;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-IsZoomed
	*/
	BOOL	IsZoomed();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-IsIconic
	*/
	BOOL	IsIconic();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-SetFont
	*/
	void SetFont(int nFontNumber);
	
	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-GetDlgItem
	*/
	Window	GetDlgItem(int nChildWinID);
	
	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-GetParent
	*/
	Window	GetParent();
		
	// Comments last updated by Iris on 07/23/2008, added #
	/**#
	*/
	Window* GetParentWndPtr();

#ifdef	ORIGIN_COM_SUPPORT
	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-GetActiveXControl
	*/
	_VARIANT GetActiveXControl();
	
#endif //#ifdef	ORIGIN_COM_SUPPORT

	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-GetDC
	*/
	DeviceContext GetDC( );
	
	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-GetCheckedRadioButton
	*/
	int GetCheckedRadioButton( int nIDFirstButton, int nIDLastButton );
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-CheckRadioButton
	*/
	void CheckRadioButton( int nIDFirstButton, int nIDLastButton, int nIDCheckButton );
#if _OC_VER >= 0x0800
	// Comments last updated by Frank on 03/25/2005
	/**#
		Parameters:
		
			clsid 		= [input]	The unique class ID of the control.
			nStyle 		= [input]	Windows styles. The available styles are listed under Remarks.
			rect 		= [input]	Specifies the control size's and position. It can be either a CRect object or a RECT structure.
			hWndParent 	= [input] 	Specifies the control's parent window. It must not be NULL.
			nID 		= [input]	Specifies the control's ID.
						
			bstrLicKey	= [input]	Optional license key data. This data is needed only for creating controls that require a run-time license key. If the control supports licensing, you must provide a license key for the creation of the control to succeed. The default value is NULL.
			nSizeLic 	= [input] 	size of the pointer to bstrLicKey

		Return:
			returns non zero is successful, otherwise zero.
		Example1:
			BOOL OnInitDialog()
			{
				//Some init codes
				RECT rect = {2,2, 300, 200};
				//0xf026c11, 0x5a66, 0x4c2b, { 0x87, 0xb5, 0x88, 0xdd, 0xeb, 0xae, 0x72, 0xa1 }
				GUID clsid;
			    clsid.Data1 = 0xf026c11;
			    clsid.Data2 = 0x5a66;
			    clsid.Data3 = 0x4c2b;
			    clsid.Data4[0] = 0x87;
			    clsid.Data4[1] = 0xb5;
			    clsid.Data4[2] = 0x88;
			    clsid.Data4[3] = 0xdd;
			    clsid.Data4[4] = 0xeb;
			    clsid.Data4[5] = 0xae;
			    clsid.Data4[6] = 0x72;
			    clsid.Data4[7] = 0xa1;
			    
				int nStyle = WS_CHILD | WS_VISIBLE;
		
				WorksheetPage pg;
				pg.Create("myPage");
				Window wndNew = pg.GetWindow();
				HWND hWndThis = GetSafeHwnd();
				wndNew.CreateActiveXControl(clsid, nStyle, rect, hWndThis, 6959);
				pg.Destroy();
				//More codes
				return TRUE;
		
			}
	*/
	BOOL	CreateActiveXControl(GUID &clsid, uint nStyle, RECT& rect, HWND hWndParent, UINT nID, short* bstrLicKey=NULL, int nSizeLic = 0);
#endif// _OC_VER >= 0x0800
	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-SizeMoveChildWindows
	*/
	int SizeMoveChildWindows(vector<uint> &hWnds, RECT *pClientRects);
	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-GetControlType
	*/
	int GetControlType();
	
	// Comments last updated by Frank on 03/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-FontName
	*/
	string FontName;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Window-FontSize
	*/
	double	FontSize;// in points
	

};




/*
 * ShowWindow() Commands
 */
#define SW_HIDE             0
#define SW_SHOWNORMAL       1
#define SW_NORMAL           1
#define SW_SHOWMINIMIZED    2
#define SW_SHOWMAXIMIZED    3
#define SW_MAXIMIZE         3
#define SW_SHOWNOACTIVATE   4
#define SW_SHOW             5
#define SW_MINIMIZE         6
#define SW_SHOWMINNOACTIVE  7
#define SW_SHOWNA           8
#define SW_RESTORE          9
#define SW_SHOWDEFAULT      10
#define SW_FORCEMINIMIZE    11
#define SW_MAX              11

#ifndef NOSCROLL

/*
 * Scroll Bar Constants
 */
#define SB_HORZ             0
#define SB_VERT             1
#define SB_CTL              2
#define SB_BOTH             3

/*
 * Scroll Bar Commands
 */
#define SB_LINEUP           0
#define SB_LINELEFT         0
#define SB_LINEDOWN         1
#define SB_LINERIGHT        1
#define SB_PAGEUP           2
#define SB_PAGELEFT         2
#define SB_PAGEDOWN         3
#define SB_PAGERIGHT        3
#define SB_THUMBPOSITION    4
#define SB_THUMBTRACK       5
#define SB_TOP              6
#define SB_LEFT             6
#define SB_BOTTOM           7
#define SB_RIGHT            7
#define SB_ENDSCROLL        8

#endif /* !NOSCROLL */


#endif // _OC_VER > 0x0703
//-------- end ORIGIN_8_FEATURES

#pragma dll(kernel32, system)


#define MAX_PATH          260
#define MAKEWORD(a, b)      ((WORD)(((BYTE)(a)) | ((WORD)((BYTE)(b))) << 8))	///Jasmine
#define MAKELONG(a, b)      ((LONG)(((WORD)(a)) | ((DWORD)((WORD)(b))) << 16))
#define LOWORD(l)           ((WORD)(l))
#define HIWORD(l)           ((WORD)(((DWORD)(l) >> 16) & 0xFFFF))
#define LOBYTE(w)           ((BYTE)(w))
#define HIBYTE(w)           ((BYTE)(((WORD)(w) >> 8) & 0xFF))

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:DeleteFile
*/
#define DeleteFile  DeleteFileA
// Comments last updated by Frank on 03/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DeleteFile_(global_function)
*/
BOOL WINAPI DeleteFile(LPCTSTR lpFileName); // Delete an existing file.

// Comments last updated by Frank on 03/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetTickCount_(global_function)
*/
UINT WINAPI GetTickCount();// Retrieve number of milliseconds elapsed since the system was started

// Comments last updated by Frank on 03/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetVersion_(global_function)
*/
UINT WINAPI GetVersion();

// Comments last updated by Frank on 03/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Sleep_(global_function)
*/
void WINAPI Sleep(DWORD dwMilliseconds);


////////////////////////////////////////////////////////
////// begin Global memory functions
////////////////////////////////////////////////////////
typedef HANDLE HGLOBAL;
#define GMEM_FIXED          0x0000
#define GMEM_MOVEABLE       0x0002
#define GMEM_NOCOMPACT      0x0010
#define GMEM_NODISCARD      0x0020
#define GMEM_ZEROINIT       0x0040
#define GMEM_MODIFY         0x0080
#define GMEM_DISCARDABLE    0x0100
#define GMEM_NOT_BANKED     0x1000
#define GMEM_SHARE          0x2000
#define GMEM_DDESHARE       0x2000
#define GMEM_NOTIFY         0x4000
#define GMEM_LOWER          GMEM_NOT_BANKED
#define GMEM_VALID_FLAGS    0x7F72
#define GMEM_INVALID_HANDLE 0x8000

#define GHND                (GMEM_MOVEABLE | GMEM_ZEROINIT)

// Comments last updated by Frank on 03/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GlobalAlloc_(global_function)
*/
HGLOBAL WINAPI GlobalAlloc(UINT uFlags, DWORD dwBytes);

// Comments last updated by Frank on 03/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GlobalReAlloc_(global_function)
*/
HGLOBAL WINAPI GlobalReAlloc(HGLOBAL hMem, DWORD dwBytes, UINT uFlags);

// Comments last updated by Frank on 03/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GlobalFree_(global_function)
*/
HGLOBAL WINAPI GlobalFree(HGLOBAL hMem);

// Comments last updated by Frank on 03/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GlobalSize_(global_function)
*/
DWORD WINAPI GlobalSize(HGLOBAL hMem);



/// AW 02/02/09 QA80-13048 SUPPORT_NAMED_PIPE_IN_ORIGINC
#define PIPE_ACCESS_INBOUND         0x00000001
#define PIPE_ACCESS_OUTBOUND        0x00000002
#define PIPE_ACCESS_DUPLEX          0x00000003

#define PIPE_WAIT                   0x00000000
#define PIPE_NOWAIT                 0x00000001
#define PIPE_READMODE_BYTE          0x00000000
#define PIPE_READMODE_MESSAGE       0x00000002
#define PIPE_TYPE_BYTE              0x00000000
#define PIPE_TYPE_MESSAGE           0x00000004

#define PIPE_UNLIMITED_INSTANCES    255

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CallNamedPipe_(global_function)
*/
BOOL WINAPI CallNamedPipe(
  LPCTSTR lpNamedPipeName,  // pipe name
  LPVOID lpInBuffer,        // write buffer
  DWORD nInBufferSize,      // size of write buffer
  LPVOID lpOutBuffer,       // read buffer
  DWORD nOutBufferSize,     // size of read buffer
  LPDWORD lpBytesRead,      // number of bytes read
  DWORD nTimeOut            // time-out value
);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetNamedPipeHandleState_(global_function)
*/
BOOL WINAPI SetNamedPipeHandleState(
  HANDLE hNamedPipe,             // handle to named pipe
  LPDWORD lpMode,                // new pipe mode
  LPDWORD lpMaxCollectionCount,  // maximum collection count
  LPDWORD lpCollectDataTimeout   // time-out value
);
//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:WaitNamedPipe
*/
#define WaitNamedPipe WaitNamedPipeA
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:WaitNamedPipe_(global_function)
*/
BOOL WINAPI WaitNamedPipe(
  LPCTSTR lpNamedPipeName,  // pipe name
  DWORD nTimeOut            // time-out interval
);
/// END SUPPORT_NAMED_PIPE_IN_ORIGINC



// Comments last updated by Frank on 03/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GlobalLock_(global_function)
*/
LPVOID WINAPI GlobalLock(HGLOBAL hMem);

// Comments last updated by Frank on 03/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GlobalUnlock_(global_function)
*/
BOOL WINAPI GlobalUnlock(HGLOBAL hMem);

// Comments last updated by Sandy on 09/14/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GlobalHandle_(global_function)
*/
HGLOBAL WINAPI GlobalHandle(LPVOID pMem);


////////////////////////////////////////////////////////
////// end Global memory functions
////////////////////////////////////////////////////////
//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:SetEnvironmentVariable
*/
#define SetEnvironmentVariable  SetEnvironmentVariableA
//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:GetEnvironmentVariable
*/
#define GetEnvironmentVariable  GetEnvironmentVariableA

// Comments last updated by Frank on 03/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetEnvironmentVariable_(global_function)
*/
DWORD WINAPI GetEnvironmentVariable(LPCSTR lpcszName, LPSTR lpBuffer, DWORD nSize);

// Comments last updated by Frank on 03/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetEnvironmentVariable_(global_function)
*/
BOOL WINAPI SetEnvironmentVariable(LPCSTR lpcszName, LPCSTR lpcszValue);

// Comments last updated by Frank on 03/25/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CloseHandle_(global_function)
*/
BOOL WINAPI CloseHandle(HANDLE hObject);

//
//  The following are masks for the predefined standard access types
//
#define DELETE                           (0x00010000L)
#define READ_CONTROL                     (0x00020000L)
#define WRITE_DAC                        (0x00040000L)
#define WRITE_OWNER                      (0x00080000L)
#define SYNCHRONIZE                      (0x00100000L)

#define STANDARD_RIGHTS_REQUIRED         (0x000F0000L)
#define STANDARD_RIGHTS_READ             (READ_CONTROL)
#define STANDARD_RIGHTS_WRITE            (READ_CONTROL)
#define STANDARD_RIGHTS_EXECUTE          (READ_CONTROL)

#define STANDARD_RIGHTS_ALL              (0x001F0000L)
#define SPECIFIC_RIGHTS_ALL              (0x0000FFFFL)
//
// AccessSystemAcl access type
//
#define ACCESS_SYSTEM_SECURITY           (0x01000000L)
//
// MaximumAllowed access type
//
#define MAXIMUM_ALLOWED                  (0x02000000L)
//
//  These are the generic rights.
//
#define GENERIC_READ                     (0x80000000L)
#define GENERIC_WRITE                    (0x40000000L)
#define GENERIC_EXECUTE                  (0x20000000L)
#define GENERIC_ALL                      (0x10000000L)
#define CREATE_NEW          1
#define CREATE_ALWAYS       2
#define OPEN_EXISTING       3
#define OPEN_ALWAYS         4
#define TRUNCATE_EXISTING   5

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:CreateFile
*/
#define CreateFile  CreateFileA
// Comments last updated by Frank on 04/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SECURITY_ATTRIBUTES
*/
typedef struct _SECURITY_ATTRIBUTES {
    DWORD nLength;
    LPVOID lpSecurityDescriptor;
    BOOL bInheritHandle;
} SECURITY_ATTRIBUTES, *PSECURITY_ATTRIBUTES, *LPSECURITY_ATTRIBUTES; /// AW 02/02/09 QA80-13048 SUPPORT_NAMED_PIPE_IN_ORIGINC


// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CreateFile_(global_function)
*/
HANDLE WINAPI CreateFile(LPCSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, SECURITY_ATTRIBUTES* lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile);

// Comments last updated by Frank on 04/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:OVERLAPPED
*/
typedef struct _OVERLAPPED {
    DWORD   Internal;
    DWORD   InternalHigh;
    DWORD   Offset;
    DWORD   OffsetHigh;
    HANDLE  hEvent;
} OVERLAPPED, *LPOVERLAPPED;  /// AW 02/02/09 QA80-13048 SUPPORT_NAMED_PIPE_IN_ORIGINC


// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:WriteFile_(global_function)
*/
BOOL WINAPI WriteFile(HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToWrite, DWORD* lpNumberOfBytesWritten, OVERLAPPED* lpOverlapped = NULL);

/// AW 02/02/09 QA80-13048 SUPPORT_NAMED_PIPE_IN_ORIGINC
//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:CreateNamedPipe
*/
#define CreateNamedPipe CreateNamedPipeA
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CreateNamedPipe_(global_function)
*/
HANDLE WINAPI CreateNamedPipe(
  LPCTSTR lpName,                             // pipe name
  DWORD dwOpenMode,                           // pipe open mode
  DWORD dwPipeMode,                           // pipe-specific modes
  DWORD nMaxInstances,                        // maximum number of instances
  DWORD nOutBufferSize,                       // output buffer size
  DWORD nInBufferSize,                        // input buffer size
  DWORD nDefaultTimeOut,                      // time-out interval
  PSECURITY_ATTRIBUTES lpSecurityAttributes  // SD
);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DisconnectNamedPipe_(global_function)
*/
BOOL WINAPI DisconnectNamedPipe(
  HANDLE hNamedPipe   // handle to named pipe
);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetNamedPipeHandleState_(global_function)
*/
BOOL WINAPI GetNamedPipeHandleState(
  HANDLE hNamedPipe,             // handle to named pipe
  LPDWORD lpState,               // pipe state
  LPDWORD lpCurInstances,        // number of pipe instances
  LPDWORD lpMaxCollectionCount,  // maximum collection count 
  LPDWORD lpCollectDataTimeout,  // time before transmission
  LPSTR lpUserName,             // client user name
  DWORD nMaxUserNameSize         // size of user name buffer
);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetNamedPipeInfo_(global_function)
*/
BOOL WINAPI GetNamedPipeInfo(
  HANDLE hNamedPipe,        // handle to named pipe
  LPDWORD lpFlags,          // pipe type 
  LPDWORD lpOutBufferSize,  // size of output buffer
  LPDWORD lpInBufferSize,   // size of input buffer
  LPDWORD lpMaxInstances    // maximum number of pipe instances
);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:PeekNamedPipe_(global_function)
*/
BOOL WINAPI PeekNamedPipe(
  HANDLE hNamedPipe,              // handle to pipe
  LPVOID lpBuffer,                // data buffer
  DWORD nBufferSize,              // size of data buffer
  LPDWORD lpBytesRead,            // number of bytes read
  LPDWORD lpTotalBytesAvail,      // number of bytes available
  LPDWORD lpBytesLeftThisMessage  // unread bytes
);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:TransactNamedPipe_(global_function)
*/
BOOL WINAPI TransactNamedPipe(
  HANDLE hNamedPipe,          // handle to named pipe
  LPVOID lpInBuffer,          // write buffer
  DWORD nInBufferSize,        // size of write buffer
  LPVOID lpOutBuffer,         // read buffer
  DWORD nOutBufferSize,       // size of read buffer
  LPDWORD lpBytesRead,        // bytes read
  LPOVERLAPPED lpOverlapped   // overlapped structure
);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CreatePipe_(global_function)
*/
BOOL WINAPI CreatePipe(
  HANDLE *hReadPipe,                       // read handle
  HANDLE *hWritePipe,                      // write handle
  PSECURITY_ATTRIBUTES lpPipeAttributes,  // security attributes
  DWORD nSize                              // pipe size
);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ConnectNamedPipe_(global_function)
*/
BOOL WINAPI ConnectNamedPipe(
  HANDLE hNamedPipe,          // handle to named pipe
  LPOVERLAPPED lpOverlapped   // overlapped structure
);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ReadFile_(global_function)
*/
BOOL WINAPI ReadFile(
  HANDLE hFile,                // handle to file
  LPVOID lpBuffer,             // data buffer
  DWORD nNumberOfBytesToRead,  // number of bytes to read
  LPDWORD lpNumberOfBytesRead, // number of bytes read
  LPOVERLAPPED lpOverlapped    // overlapped buffer
);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:FlushFileBuffers_(global_function)
*/
BOOL WINAPI FlushFileBuffers(
  HANDLE hFile  // handle to file
);

typedef DWORD (WINAPI *PTHREAD_START_ROUTINE)(
    LPVOID lpThreadParameter
    );
typedef PTHREAD_START_ROUTINE LPTHREAD_START_ROUTINE;

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CreateThread_(global_function)
*/
HANDLE WINAPI CreateThread(
  PSECURITY_ATTRIBUTES lpThreadAttributes, // SD
  DWORD dwStackSize,                       // initial stack size
  LPTHREAD_START_ROUTINE lpStartAddress,    // thread function
  LPVOID lpParameter,                       // thread argument
  DWORD dwCreationFlags,                    // creation option
  LPDWORD lpThreadId                        // thread identifier
);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetLastError_(global_function)
*/
void WINAPI SetLastError( DWORD dwErrCode );
DWORD WINAPI GetLastError();
/// END SUPPORT_NAMED_PIPE_IN_ORIGINC


// Comments last updated by Frank on 04/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:FILETIME
*/
typedef struct _FILETIME {
    DWORD dwLowDateTime;
    DWORD dwHighDateTime;
} FILETIME;

#define INVALID_HANDLE_VALUE (HANDLE)-1

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:FindFirstFile
*/
#define FindFirstFile  FindFirstFileA
//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:FindNextFile
*/
#define FindNextFile  FindNextFileA
// Comments last updated by Frank on 04/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:WIN32_FIND_DATAA
*/
typedef struct _WIN32_FIND_DATAA {
    DWORD dwFileAttributes;
    FILETIME ftCreationTime;
    FILETIME ftLastAccessTime;
    FILETIME ftLastWriteTime;
    DWORD nFileSizeHigh;
    DWORD nFileSizeLow;
    DWORD dwReserved0;
    DWORD dwReserved1;
    char   cFileName[ MAX_PATH ];
    char   cAlternateFileName[ 14 ];
} WIN32_FIND_DATAA;

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:FindFirstFile_(global_function)
*/
HANDLE WINAPI FindFirstFile(LPCSTR lpFileName, WIN32_FIND_DATAA *lpFindFileData);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:FindNextFile_(global_function)
*/
BOOL WINAPI	FindNextFile(HANDLE hFindFile, WIN32_FIND_DATAA *lpFindFileData);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:FindClose_(global_function)
*/
BOOL WINAPI	FindClose(HANDLE hFindFile);
// Comments last updated by Frank on 04/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:WIN32_FILE_ATTRIBUTE_DATA
*/
typedef struct _WIN32_FILE_ATTRIBUTE_DATA {
    DWORD dwFileAttributes;
    FILETIME ftCreationTime;
    FILETIME ftLastAccessTime;
    FILETIME ftLastWriteTime;
    DWORD nFileSizeHigh;
    DWORD nFileSizeLow;
} WIN32_FILE_ATTRIBUTE_DATA;

#define FILE_SHARE_READ                 0x00000001  
#define FILE_SHARE_WRITE                0x00000002  
#define FILE_SHARE_DELETE               0x00000004  
// dwFileAttributes are defined as follows
#define FILE_ATTRIBUTE_READONLY             0x00000001  
#define FILE_ATTRIBUTE_HIDDEN               0x00000002  
#define FILE_ATTRIBUTE_SYSTEM               0x00000004  
#define FILE_ATTRIBUTE_DIRECTORY            0x00000010  
#define FILE_ATTRIBUTE_ARCHIVE              0x00000020  
#define FILE_ATTRIBUTE_ENCRYPTED            0x00000040  
#define FILE_ATTRIBUTE_NORMAL               0x00000080  
#define FILE_ATTRIBUTE_TEMPORARY            0x00000100  
#define FILE_ATTRIBUTE_SPARSE_FILE          0x00000200  
#define FILE_ATTRIBUTE_REPARSE_POINT        0x00000400  
#define FILE_ATTRIBUTE_COMPRESSED           0x00000800  
#define FILE_ATTRIBUTE_OFFLINE              0x00001000  
#define FILE_ATTRIBUTE_NOT_CONTENT_INDEXED  0x00002000  


//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:GetFileAttributes
*/
#define GetFileAttributes  GetFileAttributesA
// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFileAttributes_(global_function)
*/
DWORD WINAPI GetFileAttributes(LPCSTR lpcszFilename);

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:GetFileAttributesEx
*/
#define GetFileAttributesEx  GetFileAttributesExA
// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFileAttributesEx_(global_function)
*/
BOOL WINAPI GetFileAttributesEx(LPCSTR lpcszFilename, int nInfoLevel, WIN32_FILE_ATTRIBUTE_DATA* lpFileInfo);

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:SetFileAttributes
*/
#define SetFileAttributes  SetFileAttributesA
// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetFileAttributes_(global_function)
*/
BOOL WINAPI SetFileAttributes(LPCSTR lpcszFilename,DWORD dwFileAttributes); //set a file's attributes


//
// Routines to convert back and forth between system time and file time
//
// Comments last updated by Frank on 03/29/2005
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:FileTimeToSystemTime_(global_function)
*/
BOOL WINAPI FileTimeToSystemTime(
    const FILETIME *lpFileTime,
    SYSTEMTIME* lpSystemTime
    );

// Comments last updated by Frank on 03/29/2005
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SystemTimeToFileTime_(global_function)
*/
BOOL WINAPI SystemTimeToFileTime(
    const SYSTEMTIME *lpSystemTime,
    FILETIME* lpFileTime
    );

// Comments last updated by Frank on 03/29/2005
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetFileTime_(global_function)
*/
BOOL WINAPI SetFileTime(HANDLE hFile, const FILETIME *lpCreationTime, const FILETIME *lpLastAccessTime, const FILETIME *lpLastWriteTime);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFileTime_(global_function)
*/
BOOL WINAPI GetFileTime(
						HANDLE hFile, 
						FILETIME *lpCreationTime,
						FILETIME *lpLastAccessTime,
						FILETIME *lpLastWriteTime
						);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetSystemTime_(global_function)
*/
void WINAPI GetSystemTime(SYSTEMTIME* lpSystemTime);

    
// Comments last updated by Frank on 03/29/2005
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:FileTimeToLocalFileTime_(global_function)
*/
BOOL WINAPI FileTimeToLocalFileTime(
    const FILETIME *lpFileTime,	// file time to convert
    FILETIME* lpLocalFileTime	// receives system time
    );

// Comments last updated by Frank on 03/29/2005
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LocalFileTimeToFileTime_(global_function)
*/
BOOL WINAPI LocalFileTimeToFileTime(
    const FILETIME *lpLocalFileTime,
    FILETIME* lpFileTime
    );

// Comments last updated by Frank on 03/29/2005
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CompareFileTime_(global_function)
*/
LONG WINAPI CompareFileTime(
    const FILETIME *lpFileTime1,
    const FILETIME *lpFileTime2
    );

// Comments last updated by Frank on 03/29/2005
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:FileTimeToDosDateTime_(global_function)
*/
BOOL WINAPI FileTimeToDosDateTime(
    const FILETIME *lpFileTime,
    WORD* lpFatDate,
    WORD* lpFatTime
    );

// Comments last updated by Frank on 03/29/2005
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DosDateTimeToFileTime_(global_function)
*/
BOOL WINAPI DosDateTimeToFileTime(
    WORD wFatDate,
    WORD wFatTime,
    FILETIME* lpFileTime
    );

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:GetTempPath
*/
#define	GetTempPath	GetTempPathA
// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetTempPath_(global_function)
*/
DWORD WINAPI GetTempPath(
	DWORD nBufferLength, 
	LPSTR lpBuffer);

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:GetTempFileName
*/
#define	GetTempFileName	GetTempFileNameA
// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetTempFileName_(global_function)
*/
DWORD WINAPI GetTempFileName(
	LPCSTR lpPathName, 
	LPCSTR lpPrefixString, 
	DWORD uUnique, 
	LPSTR lpTempFileName);


//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:CreateDirectory
*/
#define CreateDirectory  CreateDirectoryA
// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CreateDirectory_(global_function)
*/
BOOL WINAPI CreateDirectory(LPCSTR lpPathName,SECURITY_ATTRIBUTES * lpSecurityAttributes);
//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:RemoveDirectory
*/
#define RemoveDirectory  RemoveDirectoryA
// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:RemoveDirectory_(global_function)
*/
BOOL WINAPI RemoveDirectory(LPCSTR lpPathName   );

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:MoveFile
*/
#define MoveFile MoveFileA
// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MoveFile_(global_function)
*/
BOOL WINAPI MoveFile(LPCSTR lpExistingFileName, LPCSTR lpNewFileName);

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:CopyFile
*/
#define CopyFile CopyFileA
// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CopyFile_(global_function)
*/
BOOL WINAPI CopyFile(LPCSTR lpExistingFileName, LPCSTR lpNewFileName, BOOL bFailIfExists = FALSE);

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:GetComputerName
*/
#define GetComputerName GetComputerNameA
// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetComputerName_(global_function)
*/
BOOL WINAPI GetComputerName(LPSTR lpBuffer, DWORD* lpnSize);

//------------ TD 10/01/2009 ADD_SHELL_EXEC_SUPPORT
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:WinExec_(global_function)
*/
int WINAPI WinExec(LPCSTR lpCmdLine, UINT uCmdShow);

//
// dwCreationFlags (Process Creation Flags) used in CreateProcess 
//
#define DEBUG_PROCESS               0x00000001
#define DEBUG_ONLY_THIS_PROCESS     0x00000002

#define CREATE_SUSPENDED            0x00000004

#define DETACHED_PROCESS            0x00000008

#define CREATE_NEW_CONSOLE          0x00000010

#define NORMAL_PRIORITY_CLASS       0x00000020
#define IDLE_PRIORITY_CLASS         0x00000040
#define HIGH_PRIORITY_CLASS         0x00000080
#define REALTIME_PRIORITY_CLASS     0x00000100

#define CREATE_NEW_PROCESS_GROUP    0x00000200
#define CREATE_UNICODE_ENVIRONMENT  0x00000400

#define CREATE_SEPARATE_WOW_VDM     0x00000800
#define CREATE_SHARED_WOW_VDM       0x00001000
#define CREATE_FORCEDOS             0x00002000

#define CREATE_BREAKAWAY_FROM_JOB	0x01000000
#define CREATE_PRESERVE_CODE_AUTHZ_LEVEL 0x02000000
#define CREATE_DEFAULT_ERROR_MODE   0x04000000
#define CREATE_NO_WINDOW            0x08000000
//probably don't need these in OC
//#define PROFILE_USER                0x10000000
//#define PROFILE_KERNEL              0x20000000
//#define PROFILE_SERVER              0x40000000

//
// dwFlags in STARTUPINFO Structure
//
#define STARTF_USESHOWWINDOW    0x00000001
#define STARTF_USESIZE          0x00000002
#define STARTF_USEPOSITION      0x00000004
#define STARTF_USECOUNTCHARS    0x00000008
#define STARTF_USEFILLATTRIBUTE 0x00000010
#define STARTF_RUNFULLSCREEN    0x00000020  // ignored for non-x86 platforms
#define STARTF_FORCEONFEEDBACK  0x00000040
#define STARTF_FORCEOFFFEEDBACK 0x00000080
#define STARTF_USESTDHANDLES    0x00000100
#define STARTF_USEHOTKEY        0x00000200

typedef struct _STARTUPINFO {
    DWORD   cb;
    LPSTR   lpReserved;
    LPSTR   lpDesktop;
    LPSTR   lpTitle;
    DWORD   dwX;
    DWORD   dwY;
    DWORD   dwXSize;
    DWORD   dwYSize;
    DWORD   dwXCountChars;
    DWORD   dwYCountChars;
    DWORD   dwFillAttribute;
    DWORD   dwFlags;
    WORD    wShowWindow;
    WORD    cbReserved2;
    BYTE	*lpReserved2;
    HANDLE  hStdInput;
    HANDLE  hStdOutput;
    HANDLE  hStdError;
} STARTUPINFO, *LPSTARTUPINFO;

typedef struct _PROCESS_INFORMATION {
    HANDLE hProcess;
    HANDLE hThread;
    DWORD dwProcessId;
    DWORD dwThreadId;
} PROCESS_INFORMATION, *LPPROCESS_INFORMATION;

#define CreateProcess  CreateProcessA
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CreateProcess_(global_function)
*/
BOOL WINAPI CreateProcess(
  LPCSTR lpApplicationName,
  LPSTR lpCommandLine,
  LPSECURITY_ATTRIBUTES lpProcessAttributes,
  LPSECURITY_ATTRIBUTES lpThreadAttributes,
  BOOL bInheritHandles,
  DWORD dwCreationFlags,
  LPVOID lpEnvironment,
  LPCSTR lpCurrentDirectory,
  LPSTARTUPINFO lpStartupInfo,
  LPPROCESS_INFORMATION lpProcessInformation
);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:TerminateProcess_(global_function)
*/
BOOL WINAPI TerminateProcess(HANDLE hProcess, UINT uExitCode);

//a subset of the status values that you might see in GetExitCodeProcess
#define STATUS_TIMEOUT                   0x00000102    
#define STATUS_PENDING                   0x00000103    
#define STATUS_ACCESS_VIOLATION          0xC0000005    
#define STATUS_IN_PAGE_ERROR             0xC0000006    
#define STATUS_INVALID_HANDLE            0xC0000008    
#define STATUS_NO_MEMORY                 0xC0000017    

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetExitCodeProcess_(global_function)
*/
BOOL WINAPI GetExitCodeProcess(HANDLE hProcess, LPDWORD lpExitCode);

//------------ end TD 10/01/2009 ADD_SHELL_EXEC_SUPPORT


#pragma dll(shell32, system)

#define ShellExecute  ShellExecuteA

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ShellExecute_(global_function)
*/
HINSTANCE WINAPI ShellExecute(HWND hwnd, LPCSTR lpOperation, LPCSTR lpFile, LPCSTR lpParameters, LPCSTR lpDirectory, int nShowCmd);

////////////////////////////////////////////
// functions from Win32 Advanced API dll
//
#pragma dll(Advapi32, system)

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:GetUserName
*/
#define GetUserName GetUserNameA
// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetUserName_(global_function)
*/
BOOL WINAPI GetUserName(LPSTR lpBuffer, DWORD* nSize);

////////////////////////////////////////////
// functions from Win32 User dll, mostly GUI related
//
#pragma dll(User32, system)

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetFocus_(global_function)
*/
HWND WINAPI SetFocus(HWND hWnd); // set window focus

//------ Folger 11/13/07 EXPOSE_GET_FOCUS
/**#
*/
HWND WINAPI GetFocus();		//get window focus
//------ End EXPOSE_GET_FOCUS
//Comments last updated by Sophy on 6/24/2009
/**$
*/
#define IsCharAlpha IsCharAlphaA
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:IsCharAlpha_(global_function)
*/
BOOL WINAPI IsCharAlpha(char ch);

/**# >
	The GetActiveWindow function retrieves the window handle to the active window.. 

	Return:
	The return value is the handle to the active window. NULL if none is active. 
*/
HWND WINAPI	GetActiveWindow();

 
// Comments last updated by Cloud on 03/19/2007
/**# >
	The GetDlgCtrlID function retrieves the identifier of the specified control. 
	Parameters:
		hwndCtl = [input] Handle to the control. 
	Return:
		If the function succeeds, the return value is the identifier of the control.
		If the function fails, the return value is zero. 
*/
int WINAPI GetDlgCtrlID(HWND hwndCtl);

/// ML CPY 1/28/2010 VSFLEXGRID_NEEDS_IDENTIFIER_FOR_RANOREX
#define SetWindowText	SetWindowTextA
BOOL	WINAPI	SetWindowText(HWND hWnd, LPCSTR lpString);
/// end VSFLEXGRID_NEEDS_IDENTIFIER_FOR_RANOREX


/// Comments last updated by Cloud on 03/19/2007
/**# >
		The InvalidateRect function adds a rectangle to the specified window's update region. 
		The update region represents the portion of the window's client area that must be redrawn.
	Parameters:
		hWnd = [input] Handle to the window whose update region has changed. 
				If this parameter is NULL, the system invalidates and redraws all windows,
				and sends the WM_ERASEBKGND and WM_NCPAINT messages to the window procedure before the function returns. 
		lpRect = [input] Pointer to a RECT structure that contains the client coordinates of the rectangle
				to be added to the update region. If this parameter is NULL, the entire client area is added 
				to the update region. 
		bErase = [input] Specifies whether the background within the update region is to be erased when the update region 
						is processed. If this parameter is TRUE, the background is erased when the BeginPaint function 
						is called. If this parameter is FALSE, the background remains unchanged. 
	Return:
		If the function succeeds, the return value is true.
		If the function fails, the return value is false. 
*/
BOOL WINAPI InvalidateRect(HWND hWnd, const RECT *lpRect, BOOL bErase);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:UpdateWindow_(global_function)
*/
BOOL WINAPI UpdateWindow(HWND hWnd);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DestroyWindow_(global_function)
*/
BOOL WINAPI DestroyWindow(HWND hWnd);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MapDialogRect_(global_function)
*/
BOOL WINAPI MapDialogRect(HWND hDlg, RECT * lpRect);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetDialogBaseUnits_(global_function)
*/
long WINAPI GetDialogBaseUnits(void);


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetActiveWindow_(global_function)
*/
HWND WINAPI SetActiveWindow(HWND hWnd);


/*
 * SetWindowPos Flags
 */
#define SWP_NOSIZE          0x0001
#define SWP_NOMOVE          0x0002
#define SWP_NOZORDER        0x0004
#define SWP_NOREDRAW        0x0008
#define SWP_NOACTIVATE      0x0010
#define SWP_FRAMECHANGED    0x0020  /* The frame changed: send WM_NCCALCSIZE */
#define SWP_SHOWWINDOW      0x0040
#define SWP_HIDEWINDOW      0x0080
#define SWP_NOCOPYBITS      0x0100
#define SWP_NOOWNERZORDER   0x0200  /* Don't do owner Z ordering */
#define SWP_NOSENDCHANGING  0x0400  /* Don't send WM_WINDOWPOSCHANGING */

#define HWND_TOP        ((HWND)0)
#define HWND_BOTTOM     ((HWND)1)
#define HWND_TOPMOST    ((HWND)-1)
#define HWND_NOTOPMOST  ((HWND)-2)

/**#
*/
BOOL WINAPI SetWindowPos(HWND hWnd, HWND hWndInsertAfter, int X, int Y, int cx, int cy, UINT uFlags);

#define IDOK                1
#define IDCANCEL            2
#define IDABORT             3
#define IDRETRY             4
#define IDIGNORE            5
#define IDYES               6
#define IDNO                7
#define IDCLOSE         	8
#define IDHELP          	9

#ifndef NOMB

/*
 * MessageBox() Flags
 */
#define MB_OK                       0x00000000L
#define MB_OKCANCEL                 0x00000001L
#define MB_ABORTRETRYIGNORE         0x00000002L
#define MB_YESNOCANCEL              0x00000003L
#define MB_YESNO                    0x00000004L
#define MB_RETRYCANCEL              0x00000005L


#define MB_ICONHAND                 0x00000010L
#define MB_ICONQUESTION             0x00000020L
#define MB_ICONEXCLAMATION          0x00000030L
#define MB_ICONASTERISK             0x00000040L

#define MB_ICONINFORMATION          MB_ICONASTERISK
#define MB_ICONSTOP                 MB_ICONHAND

#define MB_DEFBUTTON1               0x00000000L
#define MB_DEFBUTTON2               0x00000100L
#define MB_DEFBUTTON3               0x00000200L

#define MB_APPLMODAL                0x00000000L
#define MB_SYSTEMMODAL              0x00001000L
#define MB_TASKMODAL                0x00002000L

//#define MB_NOFOCUS                  0x00008000L
//#define MB_SETFOREGROUND            0x00010000L
//#define MB_DEFAULT_DESKTOP_ONLY     0x00020000L

//#if(WINVER >= 0x0400)
//#define MB_TOPMOST                  0x00040000L
//#define MB_RIGHT                    0x00080000L
//#define MB_RTLREADING               0x00100000L
//#endif /* WINVER >= 0x0400 */


#define MB_TYPEMASK                 0x0000000FL
#define MB_ICONMASK                 0x000000F0L
#define MB_DEFMASK                  0x00000F00L
#define MB_MODEMASK                 0x00003000L
#define MB_MISCMASK                 0x0000C000L

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:MessageBox
*/
#define MessageBox  MessageBoxA


// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MessageBox_(global_function)
*/
int WINAPI MessageBox( HWND hWnd, LPCSTR lpText, LPCSTR lpCaption = NULL, UINT uType = MB_OK );	// Open a Windows message box.

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:MessageBeep_(global_function)
*/
BOOL WINAPI MessageBeep( UINT uType );

#endif /* !NOMB */


////////////////////////////////////////////////////////
////// begin clipboard functions
////////////////////////////////////////////////////////
#ifndef NOCLIPBOARD

/*
 * Predefined Clipboard Formats
 */
#define CF_TEXT             1
#define CF_BITMAP           2
#define CF_METAFILEPICT     3
#define CF_SYLK             4
#define CF_DIF              5
#define CF_TIFF             6
#define CF_OEMTEXT          7
#define CF_DIB              8
#define CF_PALETTE          9
#define CF_PENDATA          10
#define CF_RIFF             11
#define CF_WAVE             12
#define CF_UNICODETEXT      13
#define CF_ENHMETAFILE      14

#endif /* !NOCLIPBOARD */

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:OpenClipboard_(global_function)
*/
BOOL WINAPI OpenClipboard(HWND hWndNewOwner);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CloseClipboard_(global_function)
*/
BOOL WINAPI CloseClipboard(void);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:IsClipboardFormatAvailable_(global_function)
*/
BOOL WINAPI IsClipboardFormatAvailable(UINT uFormat);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetClipboardData_(global_function)
*/
HANDLE WINAPI GetClipboardData(UINT uFormat);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetClipboardData_(global_function)
*/
HANDLE WINAPI SetClipboardData(UINT uFormat, HANDLE hMem);

// Comments last updated by Frank on 08/04/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:EmptyClipboard_(global_function)
*/
BOOL WINAPI EmptyClipboard();

////////////////////////////////////////////////////////
////// end clipboard functions
////////////////////////////////////////////////////////

//-------- CPY 11/15/02 v7.0434 ORIGIN_8_FEATURES
// Origin 8 or later
#if  _OC_VER > 0x0703

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:OffsetRect_(global_function)
*/
BOOL WINAPI OffsetRect(RECT *lprc, int dx, int dy);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:InflateRect_(global_function)
*/
BOOL WINAPI InflateRect(RECT *lprc, int dx, int dy);

// CPY 5/4/2007
// Comments last updated by Iris on 07/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:IntersectRect_(global_function)
*/
BOOL WINAPI IntersectRect(RECT *lprDst, const RECT *lprcSrc1, const RECT *lprcSrc2);

#endif //_OC_VER > 0x0703

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:IsWindowVisible_(global_function)
*/
BOOL WINAPI IsWindowVisible(HWND hWnd);

/*
 * Window Styles
 */

 
 
#define WS_OVERLAPPED       0x00000000L
#define WS_POPUP            0x80000000L
#define WS_CHILD            0x40000000L
#define WS_MINIMIZE         0x20000000L
#define WS_VISIBLE          0x10000000L
#define WS_DISABLED         0x08000000L
#define WS_CLIPSIBLINGS     0x04000000L
#define WS_CLIPCHILDREN     0x02000000L
#define WS_MAXIMIZE         0x01000000L
#define WS_CAPTION          0x00C00000L     /* WS_BORDER | WS_DLGFRAME  */
#define WS_BORDER           0x00800000L
#define WS_DLGFRAME         0x00400000L
#define WS_VSCROLL          0x00200000L
#define WS_HSCROLL          0x00100000L
#define WS_SYSMENU          0x00080000L
#define WS_THICKFRAME       0x00040000L
#define WS_GROUP            0x00020000L
#define WS_TABSTOP          0x00010000L

#define WS_MINIMIZEBOX      0x00020000L
#define WS_MAXIMIZEBOX      0x00010000L

/*
 * Edit Control Styles
 */
#define ES_LEFT             0x0000L
#define ES_CENTER           0x0001L
#define ES_RIGHT            0x0002L
#define ES_MULTILINE        0x0004L
#define ES_UPPERCASE        0x0008L
#define ES_LOWERCASE        0x0010L
#define ES_PASSWORD         0x0020L
#define ES_AUTOVSCROLL      0x0040L
#define ES_AUTOHSCROLL      0x0080L
#define ES_NOHIDESEL        0x0100L
#define ES_OEMCONVERT       0x0400L
#define ES_READONLY         0x0800L
#define ES_WANTRETURN       0x1000L
#define ES_NUMBER           0x2000L

/*
 * Extended Window Styles
 */
#define WS_EX_DLGMODALFRAME     0x00000001L
#define WS_EX_NOPARENTNOTIFY    0x00000004L
#define WS_EX_TOPMOST           0x00000008L
#define WS_EX_ACCEPTFILES       0x00000010L
#define WS_EX_TRANSPARENT       0x00000020L
#define WS_EX_MDICHILD          0x00000040L
#define WS_EX_TOOLWINDOW        0x00000080L
#define WS_EX_WINDOWEDGE        0x00000100L
#define WS_EX_CLIENTEDGE        0x00000200L
#define WS_EX_CONTEXTHELP       0x00000400L

#define WS_EX_RIGHT             0x00001000L
#define WS_EX_LEFT              0x00000000L
#define WS_EX_RTLREADING        0x00002000L
#define WS_EX_LTRREADING        0x00000000L
#define WS_EX_LEFTSCROLLBAR     0x00004000L
#define WS_EX_RIGHTSCROLLBAR    0x00000000L

#define WS_EX_CONTROLPARENT     0x00010000L
#define WS_EX_STATICEDGE        0x00020000L
#define WS_EX_APPWINDOW         0x00040000L

//#define WS_EX_OVERLAPPEDWINDOW  (WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE)
//#define WS_EX_PALETTEWINDOW     (WS_EX_WINDOWEDGE | WS_EX_TOOLWINDOW | WS_EX_TOPMOST)

#define SetWindowLong  SetWindowLongA
#define GetWindowLong  GetWindowLongA
/*
 * Window field offsets for GetWindowLong()
 */
#define GWL_WNDPROC         (-4)
#define GWL_HINSTANCE       (-6)
#define GWL_HWNDPARENT      (-8)
#define GWL_STYLE           (-16)
#define GWL_EXSTYLE         (-20)
#define GWL_USERDATA        (-21)
#define GWL_ID              (-12)

// Comments last updated by Frank on 08/04/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetWindowLong_(global_function)
*/
DWORD WINAPI SetWindowLong(HWND hWnd, int nIndex, DWORD dwNewLong);
// Comments last updated by Frank on 08/04/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetWindowLong_(global_function)
*/
DWORD WINAPI GetWindowLong(HWND hWnd, int nIndex);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ShowWindow_(global_function)
*/
BOOL WINAPI ShowWindow(HWND hWnd, int nCmdShow);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetMenu_(global_function)
*/
HMENU	WINAPI GetMenu(HWND hWnd);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetSubMenu_(global_function)
*/
HMENU WINAPI GetSubMenu( HMENU hMenu, int nPos);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:IsMenu_(global_function)
*/
BOOL WINAPI IsMenu(HMENU hMenu);
 
// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetMenu_(global_function)
*/
BOOL WINAPI SetMenu(HWND hWnd, HMENU hMenu);

#ifndef NOSYSMETRICS

/*
 * GetSystemMetrics() codes
 */
#define SM_CXSCREEN             0
#define SM_CYSCREEN             1
#define SM_CXVSCROLL            2
#define SM_CYHSCROLL            3
#define SM_CYCAPTION            4 // height of window title bar
#define SM_CXBORDER             5
#define SM_CYBORDER             6
#define SM_CXDLGFRAME           7
#define SM_CYDLGFRAME           8
#define SM_CYVTHUMB             9
#define SM_CXHTHUMB             10
#define SM_CXICON               11
#define SM_CYICON               12
#define SM_CXCURSOR             13
#define SM_CYCURSOR             14
#define SM_CYMENU               15
#define SM_CXFULLSCREEN         16
#define SM_CYFULLSCREEN         17
#define SM_CYKANJIWINDOW        18
#define SM_MOUSEPRESENT         19
#define SM_CYVSCROLL            20
#define SM_CXHSCROLL            21
#define SM_DEBUG                22
#define SM_SWAPBUTTON           23
#define SM_RESERVED1            24
#define SM_RESERVED2            25
#define SM_RESERVED3            26
#define SM_RESERVED4            27
#define SM_CXMIN                28
#define SM_CYMIN                29
#define SM_CXSIZE               30
#define SM_CYSIZE               31
#define SM_CXFRAME              32
#define SM_CYFRAME              33
#define SM_CXMINTRACK           34
#define SM_CYMINTRACK           35
#define SM_CXDOUBLECLK          36
#define SM_CYDOUBLECLK          37
#define SM_CXICONSPACING        38
#define SM_CYICONSPACING        39
#define SM_MENUDROPALIGNMENT    40
#define SM_PENWINDOWS           41
#define SM_DBCSENABLED          42
#define SM_CMOUSEBUTTONS        43

#define SM_CXFIXEDFRAME           SM_CXDLGFRAME  
#define SM_CYFIXEDFRAME           SM_CYDLGFRAME  
#define SM_CXSIZEFRAME            SM_CXFRAME     
#define SM_CYSIZEFRAME            SM_CYFRAME     

#define SM_SECURE               44
#define SM_CXEDGE               45
#define SM_CYEDGE               46
#define SM_CXMINSPACING         47
#define SM_CYMINSPACING         48
#define SM_CXSMICON             49
#define SM_CYSMICON             50
#define SM_CYSMCAPTION          51
#define SM_CXSMSIZE             52
#define SM_CYSMSIZE             53
#define SM_CXMENUSIZE           54
#define SM_CYMENUSIZE           55
#define SM_ARRANGE              56
#define SM_CXMINIMIZED          57
#define SM_CYMINIMIZED          58
#define SM_CXMAXTRACK           59
#define SM_CYMAXTRACK           60
#define SM_CXMAXIMIZED          61
#define SM_CYMAXIMIZED          62
#define SM_NETWORK              63
#define SM_CLEANBOOT            67
#define SM_CXDRAG               68
#define SM_CYDRAG               69
#define SM_SHOWSOUNDS           70
#define SM_CXMENUCHECK          71
#define SM_CYMENUCHECK          72
#define SM_SLOWMACHINE          73
#define SM_MIDEASTENABLED       74
#define SM_MOUSEWHEELPRESENT    75

#define SM_XVIRTUALSCREEN       76
#define SM_YVIRTUALSCREEN       77
#define SM_CXVIRTUALSCREEN      78
#define SM_CYVIRTUALSCREEN      79
#define SM_CMONITORS            80
#define SM_SAMEDISPLAYFORMAT    81
#define SM_CMETRICS             83

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetSystemMetrics_(global_function)
*/
int	WINAPI GetSystemMetrics(int nIndex);

#endif // NOSYSMETRICS

#ifndef NOWINMESSAGES
#define CB_GETEDITSEL               0x0140
#define CB_LIMITTEXT                0x0141
#define CB_SETEDITSEL               0x0142
#define CB_ADDSTRING                0x0143
#define CB_DELETESTRING             0x0144
#define CB_DIR                      0x0145
#define CB_GETCOUNT                 0x0146
#define CB_GETCURSEL                0x0147
#define CB_GETLBTEXT                0x0148
#define CB_GETLBTEXTLEN             0x0149
#define CB_INSERTSTRING             0x014A
#define CB_RESETCONTENT             0x014B
#define CB_FINDSTRING               0x014C
#define CB_SELECTSTRING             0x014D
#define CB_SETCURSEL                0x014E
#define CB_SHOWDROPDOWN             0x014F
#define CB_GETITEMDATA              0x0150
#define CB_SETITEMDATA              0x0151
#define CB_GETDROPPEDCONTROLRECT    0x0152
#define CB_SETITEMHEIGHT            0x0153
#define CB_GETITEMHEIGHT            0x0154
#define CB_SETEXTENDEDUI            0x0155
#define CB_GETEXTENDEDUI            0x0156
#define CB_GETDROPPEDSTATE          0x0157
#define CB_FINDSTRINGEXACT          0x0158
#define CB_SETLOCALE                0x0159
#define CB_GETLOCALE                0x015A
#define CB_GETTOPINDEX              0x015b
#define CB_SETTOPINDEX              0x015c
#define CB_GETHORIZONTALEXTENT      0x015d
#define CB_SETHORIZONTALEXTENT      0x015e
#define CB_GETDROPPEDWIDTH          0x015f
#define CB_SETDROPPEDWIDTH          0x0160
#define CB_INITSTORAGE              0x0161
#define CB_MSGMAX                   0x0162


#define LB_GETSELCOUNT          0x0190
#define LB_GETSELITEMS          0x0191
#define LB_SELITEMRANGE         0x019B


#define TBM_GETPOS              (WM_USER)
#define TBM_GETRANGEMIN         (WM_USER+1)
#define TBM_GETRANGEMAX         (WM_USER+2)
#define TBM_GETTIC              (WM_USER+3)
#define TBM_SETTIC              (WM_USER+4)
#define TBM_SETPOS              (WM_USER+5)
#define TBM_SETRANGE            (WM_USER+6)
#define TBM_SETRANGEMIN         (WM_USER+7)
#define TBM_SETRANGEMAX         (WM_USER+8)
#define TBM_CLEARTICS           (WM_USER+9)
#define TBM_SETSEL              (WM_USER+10)
#define TBM_SETSELSTART         (WM_USER+11)
#define TBM_SETSELEND           (WM_USER+12)
#define TBM_GETPTICS            (WM_USER+14)
#define TBM_GETTICPOS           (WM_USER+15)
#define TBM_GETNUMTICS          (WM_USER+16)
#define TBM_GETSELSTART         (WM_USER+17)
#define TBM_GETSELEND           (WM_USER+18)
#define TBM_CLEARSEL            (WM_USER+19)
#define TBM_SETTICFREQ          (WM_USER+20)
#define TBM_SETPAGESIZE         (WM_USER+21)
#define TBM_GETPAGESIZE         (WM_USER+22)
#define TBM_SETLINESIZE         (WM_USER+23)
#define TBM_GETLINESIZE         (WM_USER+24)
#define TBM_GETTHUMBRECT        (WM_USER+25)
#define TBM_GETCHANNELRECT      (WM_USER+26)
#define TBM_SETTHUMBLENGTH      (WM_USER+27)
#define TBM_GETTHUMBLENGTH      (WM_USER+28)
#define TBM_SETTOOLTIPS         (WM_USER+29)
#define TBM_GETTOOLTIPS         (WM_USER+30)
#define TBM_SETTIPSIDE          (WM_USER+31)
// TrackBar Tip Side flags
#define TBTS_TOP                0
#define TBTS_LEFT               1
#define TBTS_BOTTOM             2
#define TBTS_RIGHT              3

#define TBM_SETBUDDY            (WM_USER+32) // wparam = BOOL fLeft; (or right)
#define TBM_GETBUDDY            (WM_USER+33) // wparam = BOOL fLeft; (or right)
#define TBM_SETUNICODEFORMAT    CCM_SETUNICODEFORMAT
#define TBM_GETUNICODEFORMAT    CCM_GETUNICODEFORMAT

#endif  /* !NOWINMESSAGES */


/*
 * Key State Masks for Mouse Messages
 */
#define MK_LBUTTON          0x0001
#define MK_RBUTTON          0x0002
#define MK_SHIFT            0x0004
#define MK_CONTROL          0x0008
#define MK_MBUTTON          0x0010


/*
 * Virtual Keys
 */
#define VK_LBUTTON        0x01
#define VK_RBUTTON        0x02
#define VK_CANCEL         0x03
#define VK_MBUTTON        0x04    /* NOT contiguous with L & RBUTTON */

#define VK_BACK           0x08	// backspace
#define VK_TAB            0x09

#define VK_CLEAR          0x0C
#define VK_RETURN         0x0D

#define VK_SHIFT          0x10
#define VK_CONTROL        0x11
#define VK_MENU           0x12
#define VK_PAUSE          0x13
#define VK_CAPITAL        0x14

#define VK_ESCAPE         0x1B
#define VK_SPACE          0x20
#define VK_PRIOR          0x21
#define VK_NEXT           0x22
#define VK_END            0x23
#define VK_HOME           0x24
#define VK_LEFT           0x25
#define VK_UP             0x26
#define VK_RIGHT          0x27
#define VK_DOWN           0x28
#define VK_SELECT         0x29
#define VK_PRINT          0x2A
#define VK_EXECUTE        0x2B
#define VK_SNAPSHOT       0x2C
#define VK_INSERT         0x2D
#define VK_DELETE         0x2E
#define VK_HELP           0x2F
#define VK_F1             0x70
#define VK_F2             0x71
#define VK_F3             0x72
#define VK_F4             0x73
#define VK_F5             0x74
#define VK_F6             0x75
#define VK_F7             0x76
#define VK_F8             0x77
#define VK_F9             0x78
#define VK_F10            0x79

#define VK_OEM_PLUS 0xBB	//Windows 2000/XP: For any country/region, the '+' '=' key
#define VK_OEM_MINUS 0xBD

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetKeyState_(global_function)
*/
short WINAPI GetKeyState(int nVirtKey);

typedef DWORD HKL;

#define HKL_PREV            0
#define HKL_NEXT            1

#define KLF_ACTIVATE        0x00000001
#define KLF_SUBSTITUTE_OK   0x00000002
#define KLF_REORDER         0x00000008

#define KLF_REPLACELANG     0x00000010
#define KLF_NOTELLSHELL     0x00000080

#define KLF_SETFORPROCESS   0x00000100

#define KLF_SHIFTLOCK		0x00010000		
#define KLF_RESET			0x40000000
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetKeyboardLayout_(global_function)
*/
HKL WINAPI GetKeyboardLayout(DWORD dwLayout = 0);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ActivateKeyboardLayout_(global_function)
*/
HKL WINAPI ActivateKeyboardLayout(HKL hkl, UINT Flags = 0);

/*
 * OEM Resource Ordinal Numbers in winuser.h
 */
#define OBM_UPARROW         32753
#define OBM_DNARROW         32752
#define OBM_RGARROW         32751
#define OBM_LFARROW         32750
#define OBM_REDUCE          32749
#define OBM_ZOOM            32748
#define OBM_RESTORE         32747
#define OBM_REDUCED         32746
#define OBM_ZOOMD           32745
#define OBM_RESTORED        32744
#define OBM_UPARROWD        32743
#define OBM_DNARROWD        32742
#define OBM_RGARROWD        32741
#define OBM_LFARROWD        32740
#define OBM_MNARROW         32739
#define OBM_COMBO           32738
#define OBM_UPARROWI        32737
#define OBM_DNARROWI        32736
#define OBM_RGARROWI        32735
#define OBM_LFARROWI        32734

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:LoadBitmap
*/
#define LoadBitmap  LoadBitmapA

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LoadBitmap_(global_function)
*/
HBITMAP WINAPI  LoadBitmap(HINSTANCE hInstance, LPCSTR lpBitmapName);

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:LoadIcon
*/
#define LoadIcon  LoadIconA

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LoadIcon_(global_function)
*/
HICON WINAPI	LoadIcon(HINSTANCE hInstance, LPCSTR lpIconName);

//Comments last updated by Sophy on 6/24/2009
/**$
http://ocwiki.originlab.com/index.php?title=OriginC:LoadImage
*/
#define LoadImage  LoadImageA

#define IMAGE_BITMAP        0
#define IMAGE_ICON          1
#define IMAGE_CURSOR        2
#define IMAGE_ENHMETAFILE   3

#define LR_DEFAULTCOLOR     0x0000
#define LR_MONOCHROME       0x0001
#define LR_COLOR            0x0002
#define LR_COPYRETURNORG    0x0004
#define LR_COPYDELETEORG    0x0008
#define LR_LOADFROMFILE     0x0010
#define LR_LOADTRANSPARENT  0x0020
#define LR_DEFAULTSIZE      0x0040
#define LR_VGACOLOR         0x0080
#define LR_LOADMAP3DCOLORS  0x1000
#define LR_CREATEDIBSECTION 0x2000
#define LR_COPYFROMRESOURCE 0x4000
#define LR_SHARED           0x8000

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LoadImage_(global_function)
*/
HANDLE WINAPI LoadImage(HINSTANCE hInstance, LPCSTR lpszName, UINT uType,int cxDesired, int cyDesired, UINT nLoad);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DestroyIcon_(global_function)
*/
BOOL   WINAPI DestroyIcon(HICON hIcon);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetCursorPos_(global_function)
*/
BOOL WINAPI GetCursorPos(POINT* lpPoint);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GW_HWNDFIRST
*/
#define GW_HWNDFIRST        0
#define GW_HWNDLAST         1
#define GW_HWNDNEXT         2
#define GW_HWNDPREV         3
#define GW_OWNER            4
#define GW_CHILD            5

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetWindow_(global_function)
*/
HWND WINAPI GetWindow(HWND hWnd, UINT uCmd);


#pragma dll(GDI32, system)

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DeleteObject_(global_function)
*/
BOOL WINAPI DeleteObject(HGDIOBJ hGDI);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DeleteMetaFile_(global_function)
*/
BOOL WINAPI DeleteMetaFile(HMETAFILE hMF);

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DeleteEnhMetaFile_(global_function)
*/
BOOL WINAPI DeleteEnhMetaFile(HENHMETAFILE hEnhMf);

// Windows related functions exported from Origin
#pragma dll(@OK)

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetWindow_(global_function)
*/
HWND GetWindow(int nWin = OGW_MAIN); // get Origin window handle

// GetWindow was originally in utilities.h, moved to this file by CPY ADD_HWND_CONSTRUCTOR_TO_WINDOW
#pragma dll(@OUTL)

// Comments last updated by Frank on 03/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetModuleHandle_(global_function)
*/
HINSTANCE GetModuleHandle(int nModuleID = MODULE_ORIGIN);

#endif //_MSWIN_H
